# A matrix computation for posterior rank computation 

double precision function dmvg2(x, mu, Cov)

double precision x(2), mu(2), Cov(2,2)
double precision s(2), rho, z(2), K
double precision one, two, pi
parameter(one = 1.0d0)
parameter(two = 2.0d0)
parameter(pi = 3.141592653589793d0)

s(1) = dsqrt(Cov(1,1))
s(2) = dsqrt(Cov(2,2))
rho  = Cov(1,2)/(s(1)*s(2))

K = 1/(two*pi*s(1)*s(2)*dsqrt(one - rho**2))
z(1) = (x(1)-mu(1))/s(1) 
z(2) = (x(2)-mu(2))/s(2) 
dmvg2 = K * dexp(-(z(1)**2 - two*rho*z(1)*z(2) + z(2)**2)/(two*(one - rho**2)))
return
end

subroutine fdpr(p, m, n, b, t, Cov, Gx, Gy, r) 
# Input Notation:
    # p ~ number of teams
    # m ~ number of cols in Gx, Gy (grid points)
    # n ~ number of pairs combn(n,2)
    # b ` MLE ratings
    # t ~ 2 by n matrix of pairings
    # Cov ~ p by p Covariance of MLE ratings 
    # Gx ~ 2 by m matrix of mass points of Ghat
    # Gy ~ 2 by m matrix of masses on mass points of Ghat
# Output Notation:
    # r ~ n vector of probabilities
# 
integer p, m, n, t(2,n)
double precision b(p), x(2), Gx(2,m), Gy(2,m), s(2,2), r(n)
double precision den, an, ad, w, dmvg2, Cov(p-1,p-1)
double precision zero, one
parameter(zero = 0.0d0)
parameter(one = 1.0d0)

do i = 1,n{
    an = zero
    ad = zero
    if(t(1,i) > 1){
      do j = 1,m{
	x(1) = b(t(1,i))
	x(2) = b(t(2,i))
	s(1,1) = Cov(t(1,i)-1,t(1,i)-1)
	s(1,2) = Cov(t(1,i)-1,t(2,i)-1)
	s(2,1) = Cov(t(2,i)-1,t(1,i)-1)
	s(2,2) = Cov(t(2,i)-1,t(2,i)-1)
	den = dmvg2(x, Gx(1,j), s) 
	if(Gx(1,j) <= Gx(2,j)) 
	    w = one
	else
	    w = zero
	an = an + den * w * Gy(1,j) * Gy(2,j)
	ad = ad + den * Gy(1,j) * Gy(2,j)
      }
    r(i) = an/ad
    }
}
return
end
