% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JCRead.R
\name{Cites}
\alias{Cites}
\title{Citation Matrices}
\usage{
Cites(type = "Cited")
}
\arguments{
\item{type}{Cited or Citing matrix, Default: 'Cited'}
}
\value{
Square matrix of citation counts
}
\description{
Construct matrix of citation counts
}
\details{
The Cited and Citing matrices should be transposes of one
another, however the JC files don't quite reflect this, the example
code illustrates this discrepancy.
}
\examples{
Cited <- Cites()
Citing <- Cites(type = "Citing")
# Sanity check:  Data in the Cited and Citing matrices should match.
# They do not, but the discrepancies are modest.
A <- data.matrix(Cited)
B <- data.matrix(Citing)
C0 <- all.equal(A,t(B))
C1 <- sum(A != t(B))
mn <- which(A != t(B))
D <- cbind(mn \%/\% 86, 1 + mn \%\% 86, A[A != t(B)], t(B)[A != t(B)])
}
