## ----sim, include = FALSE-----------------------------------------------------
require(RRpairwise)
require(REBayes)
knitr::render_sweave()
knitr::set_alias(w = "fig.width", h = "fig.height")

## ----sim1, eval = FALSE-------------------------------------------------------
#  sessionInfo()
#  set.seed(1729)
#  meths <- c("MLE", "KWPM", "KWPMs", "KWPR","RMLE", "B", "WB")
#  ms <- c(1000, 5000, 10000, 50000,100000)
#  n <- 100
#  R <- 100
#  K <- array(0, c(length(meths), length(ms), R))
#  kcor <- function(x,a) cor(x, a, method = "kendall")
#  for(j in 1:length(ms)){
#    for(i in 1:R){
#      a <- sample(c(4,8), n, prob = c(0.8, 0.2), replace = TRUE) + rnorm(n, sd = 1/3)
#      a <- sort(a)
#      a <- a/a[1]
#      A <- matrix(0,n, length(meths))
#      D <- DGP(a, ms[j], type = "LS")
#      for(k in 1:length(meths)){
#  	A[,k] <- BTfit(D, method = meths[k])
#  	K[,j,i] <- apply(A, 2, kcor, a = a)
#  	}
#    }
#  }

## ----L10, cache = TRUE, message = FALSE, warning = FALSE----------------------
PL10cap <- "Group Lasso Plot for Citation Data"
data(citations)
lambdas <- 0:30/3
ahat0 <- BTfit(citations)
A <- matrix(0, length(ahat0), length(lambdas)) 
A[,1] <- ahat0
for(i in 2:length(lambdas))
    A[,i] <- BTfit(citations, method = "lasso", lambdas[i], refit = 0)
o <- rev(order(A[,1]))
B <- head(A[o,],10)

## ----PL10, h = 5, w = 9, fig.cap = PL10cap, message = FALSE, warning = FALSE----
Citing <- Cites(type = "Citing")
Top10 <- dimnames(Citing)[[1]][o[1:10]]
matplot(lambdas, t(B), type = 'l', xlab = expression(lambda), 
	ylab = 'Rating', lwd = 2, lty = 1:10, col = 1:10)
legend("bottomleft", legend = Top10, lwd = 2, 
       lty = 1:10, seg.len = 3, col = 1:10, cex = .75)

