% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/witness.R
\name{witness}
\alias{witness}
\title{Find witness point}
\usage{
witness(A, b, s, epsbound = 1, epstol = 1e-07, presolve = 1,
  verb = 0)
}
\arguments{
\item{A}{Is a n by d matrix of hyperplane slope coefficients.}

\item{b}{Is an n vector of hyperplane intercept coefficients.}

\item{s}{Is an n vector of signs.}

\item{epsbound}{Is a scalar tolerance controlling how close the witness 
point can be to an edge of the polytope.}

\item{epstol}{Is a scalar tolerance for the LP convergence.}

\item{presolve}{Controls whether Mosek should presolve the LP.}

\item{verb}{Controls verbosity of Mosek solution.}
}
\value{
List with components:
 \itemize{
\item  w proposed interior point at solution 
\item  fail indicator of whether w is a valid interior point
 }
}
\description{
Find (if possible) an interior point of a polytope solving a linear program
}
\details{
Solves LP:  max over {w,eps} {eps | SAw - eps >= Sb, 0 < eps <= epsbound}
S is diag(s),  if at the solution eps > 0, then w is a valid interior point
otherwise the LP fails to find an interior point, another s must be tried.
Constructs a problem formulation that can be passed to Rmosek for solution.
}
