# Simple Test Problem for rcbr
n <- 100
B0 = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
z <- rnorm(n)
v <- rnorm(n)
s <- sample(0:1, n, replace = TRUE)
XB0 <- cbind(1,z,v) %*% t(B0)
u <- s * XB0[,1] + (1-s) * XB0[,2]
y <- (u > 0) - 0
D <- data.frame(z = z, v = v, y = y)
f <- rcbr(y ~ z + v, method = "KW", data = D)
g <- rcbr(y ~ z + v, method = "KW", data = D, u = -20:20/10, v = -20:20/10)
