# Simple Test Problem for rcbr
set.seed(15)
n <- 100
B0 = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
z <- rnorm(n)
v <- rnorm(n)
s <- sample(0:1, n, replace = TRUE)
XB0 <- cbind(1,z,v) %*% t(B0)
u <- s * XB0[,1] + (1-s) * XB0[,2]
y <- (u > 0) - 0
D <- data.frame(z = z, v = v, y = y)
pdf("GK0.pdf")
f <- rcbr(y ~ z + v, method = "GK", data = D)
contour(f$u, f$v, matrix(f$w, length(f$u)))
points(x = 0.7, y = -0.7, col = 2)
points(x = -0.7, y = 0.7, col = 2)
dev.off()
pdf("GK1.pdf")
f <- rcbr(y ~ z + v, method = "GK", data = D, T = 7)
contour(f$u, f$v, matrix(f$w, length(f$u)))
points(x = 0.7, y = -0.7, col = 2)
points(x = -0.7, y = 0.7, col = 2)
dev.off()
