# example of a KW2 plot contrasting exact and gridded versions
B = rbind(c(0.7,-0.7,1),c(-0.7,0.7,1))
n = 100
z <- rnorm(n)
v <- rnorm(n)
XB <- cbind(1,z,v) %*% t(B)
s <- sample(0:1, n, replace = TRUE)
utility <- s * XB[,1] + (1-s) * XB[,2]
y <- (utility > 0) - 0
D <- data.frame(z = z, v = v, y = y)
tf <- system.time(f <- rcbr(y ~ z + v, data = D, mode = "KW", u = -80:80/40, v = -80:80/40))
tg <- system.time(g <- rcbr(y ~ z + v, data = D, mode = "KW"))
plot(f)
plot(g, add = TRUE, col = 2)


