# Critical Value Table
require(Hmisc)
load("sim2.Rda")
A <- array(unlist(AK),c(4,1000,4))
B <- apply(A,c(1,3),quantile, probs = c(.9,.95,.99))
B1 <- matrix(aperm(B,c(2,3,1)),4,12)
load("sim4.Rda")
A <- array(unlist(AK),c(2,4,1000,4))
B <- apply(A[1,,,],c(1,3),quantile, probs = c(.9,.95,.99))
B2 <- matrix(aperm(B,c(2,3,1)),4,12)
B <- rbind(B1[1:3,],B2[1:2,])
coo <- c(2.75, 3.95, 6.93,3.90, 5.37, 8.71,5.34, 6.87, 10.46, 6.38, 8.32, 11.91)
coo <- c(t(matrix(coo,3,4)))
B <- rbind(B,coo)
ms <- 1:4
rlabs <- c("100",  "500", "1,000", "5,000", "10,000", "$\\infty$")
dimnames(B) <- list(rlabs, rep(paste("[",-ms,",",ms,"]",sep = ""),3))
cap <- "Critical Values for Likelihood Ratio Test of Gaussian Parameter Homogeneity:  
The first six rows of the table report empirical critical values based on 1000 
replications of the LRT based on the Kiefer-Wolfowitz estimate of the nonparametric 
Gaussian location mixture distribution.  Results for sample sizes 5,000 and 10,000 
were computed by binning the observations into 300, 500 equally spaced bins 
respectively.
Restriction of the domain of the mixing distribution is indicated by the column labels.
The last row reproduces the simulated asymptotic critical values reported in Table 1."
latex(B,file = "SizeTab.tex", rowlabel = "n", dec = 2, rowlabel.just = "r",
	cgroup = c( "cval(.90)" , "cval(.95)" , "cval(.99)" ), 
	caption.loc = "bottom", caption = cap)
