# NOTE: This is the R code generating results in Table 1. 
# Change value for theta for different support. 



library(kernlab)

# ipop solves the quadratic programming problem :
# min(c'*x + 1/2 * x' * H * x)
# subject to:
# b <= A * x <= b + r
# l <= x <= u
# ipop(c, H, A, b, l, u, r, sigf = 7, maxiter = 40, margin = 0.05, bound = 10, verb = 0)

p = 25 # cutoff for infinite sum over k 
pot = 2:p

l.p = length(pot)

theta = 2*c((-100):(-1),1:100)/100  # grid for means, zero should be excluded 
l.theta = length(theta)

K = t(array(gamma(pot+1)^(-.5),c(l.p,l.theta)))
Mtheta = array(theta,c(l.theta,l.p))
Mp = t(array(pot,c(l.p,l.theta)))
M = K*Mtheta^Mp
M2 = M/array(rowSums(M^2)^.5,c(l.theta,l.p))

N = 10^4  # number of simulations
resu_int = numeric(N)
resu_max = numeric(N)

for(k in 1:N){
  Z = rnorm(l.p)
  MZ = t(array(Z,c(l.p,l.theta)))
  
  if(sum(rowSums(MZ*M) > 0)>0){
    # this is the part where optimization takes place
    res = ipop(c=rep(0,l.theta), H = M, A = rowSums(MZ*M), b = 1, l = rep(0,l.theta), u = rep(10^10,l.theta), r = 0,sigf = 5, maxiter = 500,bound = 20)
    res2 = 1/(t(primal(res))%*%M%*%t(M)%*%primal(res))^.5
  }else{
    res2 = 0
  }
  resu_int[k] = res2^2 

  resu_max[k] = max(max(rowSums(MZ*M2)),0)^2  # for testing purposes, should be smaller than the integral above
}

# plotting the ecdf
plot(ecdf(resu_int))
lines(ecdf(resu_max),col='red')

# resulting quantiles
.5*quantile(resu_int,c(.9,.95,.99))
