#  Simulation of null LRT behavior -- Comparison to Stanislav's Asymptotics
#  But with .01 grid spacing

require(doMC) #loads multicore and foreach automatically.
registerDoMC(4) # intention to use 4 cores
require(REBayes)

system("hostname")
date()
sessionInfo()
set.seed(1200)

logLik <- function(h,x) sum(log((2/3) * dnorm(x, -h) + (1/3) * dnorm(x, 2*h)))
ns <- c(100, 500, 1000, 5000)
ms <- 1:4
R <- 1000
M <- length(ms)
N <- length(ns)
opt <- list(set.seed = FALSE)
AK <- foreach(k = 1:M, .options.multicore = opt) %dopar% {
	A <- matrix(0,N,R)
	m <- ms[k] 
	v <- seq(-m,m,by = 0.01)
	for(i in 1:N){
		n <- ns[i]
		for(j in 1:R){
			x <- rnorm(n)
			l0 <- logLik(0,x - mean(x))
			f <- GLmix(x,v,rtol = 1e-9)
			A[i,j] <- 2 * (f$logLik - l0)
			}
		}
	A
	}
