# The Chen gamma example

require(REBayes)
set.seed(1960)
pdf(file = "exv1.pdf", height = 4, width = 9)
#quartz(height = 4, width = 9)
par(mfrow = c(1,3))
h <- 0.5
n <- 400
m <- 11
v <- sample(2 + c(-h, 2*h), n, prob = c(2/3,1/3), replace = TRUE)
x <- rnorm(m*n,sd = rep(sqrt(v), each = m))
id <- rep(1:n, each = m)
f <- GVmix(x,id)

# Plot 1 of the Mixing densities
plot(f,col = 2, xlab = "x", ylab = "f(x)", main = "Mixing Distribution")
s <- tapply(x,id,"var")
rug(s)
segments(2 + c(-h,2*h),c(0,0),2 + c(-h,2*h), c(25,12.5),lwd = 1.3, col = "blue")

# Plot 2 of the Mixture densities
y <- seq(0.1, max(s)+3, length = 500)
ghat <- function(y,f,m){ 
	r <- rep((m-1)/2,length(y))
	R <- outer(r*y,f$x,"/")
	K <- outer(gamma(r)/r,f$x)
	r <- outer(r,rep(1,length(f$x)))
	(exp(-R)*R^(r-1)/K) %*% f$y * diff(f$x)[1]
	}
hist(s,35, freq = FALSE, xlab = "x", ylab = "g(x)", main = "Mixture Distribution")
g <- ghat(y,f,m)
dy <- diff(y)[1]
logghat <- splinefun(y,log(g))
lines(y, exp(logghat(y)), col = 2) 
d1gamma <- function(y,r,v) {
	R <- r*y/v
	exp(-R)*R^(r-1)/(v * gamma(r)/r)
	}
d2gamma <- function(y, r, w = c(2/3,1/3),v = c(2-h,2+2*h)) {
	r <- (m-1)/2
	w[1]*d1gamma(y,r,v = v[1]) + w[2]*d1gamma(y,r,v = v[2])
	}
gtrue <- d2gamma(y,r)
lines(y,gtrue, col = "blue")

# Plot 3 of the Bayes Rules
delta <- function(y,g,r,log = TRUE) {
	if(log) gg <- function(y) y^(1-r) * exp(g(y))
	else gg <- function(y) y^(1-r) * g(y)
	G <- y
	for(i in 1:length(y)) G[i] <- integrate(gg,y[i],20)$value
	if(log) r*y^(r-1)*G/exp(g(y))
	else r*y^(r-1)*G/g(y)
	}
d <- delta(y,logghat,(m-1)/2)
t <- (min(s) < y) & (y < max(s))
plot(y[t], d[t], ylab = expression(delta (x)), ylim = c(1,4),
	xlab = "x", col = 2, type = "l", main = "Bayes Rule")
lines(y,delta(y,d2gamma,(m-1)/2,log = FALSE),col = "blue")
abline(c(0,1), col = "grey")
rug(s)
# Add the Robbins (1982) leB rule  eq (21)
leB <- function(y,s,r) {
	sbar <- mean(s)
	S2 <- var(s)
	sbar + max(1 - (S2 + sbar^2)/((1+r)*S2),0)*(y - sbar) 
	}
lines(y,leB(y,s,r = 5),col = "brown")

dev.off()
