# The Uniform example

require(REBayes)
set.seed(1492)
pdf(file = "ex2.pdf", height = 4, width = 9)
#quartz(height = 4, width = 9)
par(mfrow = c(1,3))
h <- 0.5
n <- 400
#mu <- sample(c(-h, 2*h), n, prob = c(2/3,1/3), replace = TRUE)
mu <- runif(n,-h, 2*h)
x <- mu + rnorm(n)
z <- GLmix(x)
plot(z,col = 2, xlab = "x", ylab = "f(x)", main = "Mixing Distribution")
rug(x)
lines(c(-h,-h,2*h,2*h),c(0,1/(3*h),1/(3*h),0),col = "blue")

#y <- seq(min(x)-1, max(x)+1, length = 500)
y <- seq(-7, 7, length = 500)
ghat <- dnorm(outer(y,z$x,"-")) %*% z$y * diff(z$x)[1]
hist(x,35, freq = FALSE, ylab = "g(x)", main = "Mixture Distribution")
lines(y,ghat, col = 2)
g <- (pnorm(2*h - y) - pnorm(-h - y))/(3*h)
lines(y,g, col = "blue")

eps <- 0.001
K <- approxfun(y, .5 * y^2 + log(ghat))
Kp <- (K(y+eps) - K(y))/eps
Km <- (K(y) - K(y - eps))/eps
delta <- approxfun(y,(Kp + Km)/2, rule = 2, method = "constant")
plot(y, delta(y), xlim = c(-7, 7), ylim = c(-.5,1), ylab = expression(delta (x)), 
	xlab = "x", col = 2, type = "l", main = "Bayes Rule")
delta <- y + (dnorm(-h - y)- dnorm(2*h - y))/(pnorm(2*h - y) - pnorm(-h - y))  
lines(y, delta, col = "blue")
abline(c(0,1), col = "grey")

dev.off()
