# The Chen example

require(REBayes)
set.seed(1492)
pdf(file = "ex1.pdf", height = 4, width = 9)
par(mfrow = c(1,3))
h <- 0.5
n <- 400
mu <- sample(c(-h, 2*h), n, prob = c(2/3,1/3), replace = TRUE)
x <- mu + rnorm(n)
z <- GLmix(x)
plot(z,col = 2, xlab = "x", ylab = "f(x)", main = "Mixing Distribution")
rug(x)
segments(c(-h,2*h),c(0,0),c(-h,2*h), c(25,12.5),lwd = 1.3, col = "blue")

y <- seq(min(x)-1, max(x)+1, length = 500)
ghat <- dnorm(outer(y,z$x,"-")) %*% z$y * diff(z$x)[1]
hist(x,35, freq = FALSE, ylab = "g(x)", main = "Mixture Distribution")
lines(y,ghat, col = 2)
g <- 2*dnorm(y,-h)/3 + dnorm(y,2*h)/3
lines(y,g, col = "blue")

eps <- 0.001
K <- approxfun(y, .5 * y^2 + log(ghat))
Kp <- (K(y+eps) - K(y))/eps
Km <- (K(y) - K(y - eps))/eps
delta <- approxfun(y,(Kp + Km)/2, rule = 2, method = "constant")
plot(y, delta(y), ylab = expression(delta (x)), 
	xlab = "x", col = 2, type = "l", main = "Bayes Rule")
rug(x)
gm <- log(2*dnorm(y-eps,-h)/3 + dnorm(y-eps,2*h)/3)
gp <- log(2*dnorm(y+eps,-h)/3 + dnorm(y+eps,2*h)/3)
lines(y, y + (gp - gm)/(2*eps),col = "blue")
abline(c(0,1),col = "grey")

dev.off()
