require(REBayes)
require(foreign)

source("plot.WGLVmix.R")
load("MP_Profile_twofactor.Rda")
best <- which.max(LogLik)
f$fuv <- fmix[,best]
f$v <- fv[,best]
f$u <- fu[,best]
f$rho <- rhos[best]



# high mean + high vol : low mean + high volatility 
#nid = c(44,1)
#par(mfrow = c(1,2))
#plot.WGLVmix(nid, f,T0 = 8)


# high mean + high vol : low mean + low vol
#nid = c(4,143)
#par(mfrow = c(1,2))
#plot.WGLVmix(nid, f,T0 = 8)

# high mean + low vol : low mean + high volatility 
#nid = c(21,59)
#par(mfrow = c(1,2))
#plot.WGLVmix(nid, f,T0 = 8)

# high mean + low vol : low mean + low volatility 
#nid = c(180,252)
#par(mfrow = c(1,2))
#plot.WGLVmix(nid, f,T0 = 8)

# Two pairs
# Pair 1 (Upper): high mean + high vol :versus: low mean + high vol
# Pair 2 (Lower): high mean + high vol :versus: low mean + low vol
pdf("MP_Prediction1.pdf",height = 6, width = 9)
#nid = c(44,1,4,143)
#par(mfrow=c(2,2))
nid = c(44,1)
par(mfrow=c(1,2))
plot.WGLVmix(nid, f,T0 = 8)
dev.off()

# Two pairs
# Pair 1 (Upper): high mean + low vol :versus: low mean + high vol
# Pair 2 (Lower): high mean + low vol :versus: low mean + low vol
pdf("MP_Prediction2.pdf",height = 6, width = 9)
#nid = c(21,59,180,252)
#par(mfrow=c(2,2))
nid = c(21,59)
par(mfrow=c(1,2))
plot.WGLVmix(nid, f,T0 = 8)
dev.off()

# Use same high mean + high vol guy, compare with a low mean + high vol guy and a low mean + low vol guy
pdf("MP_Prediction3.pdf",height = 4, width = 12)
nid = c(44,1,143)
par(mfrow=c(1,3))
plot.WGLVmix(nid, f,T0 = 8)
dev.off()

# Use same high mean + low vol guy, compare with a low mean + high vol guy and a low mean + low vol guy
pdf("MP_Prediction4.pdf",height = 4, width = 12)
nid = c(21,59,252)
par(mfrow=c(1,3))
plot.WGLVmix(nid, f,T0 = 8)
dev.off()

##########
# Plot for fun
#nid = sample(1:900,2)
#par(mfrow = c(1,2))
#plot.WGLVmix(nid, f)
#plot.WGLVmix(nid, f, hex = TRUE)

## selection process
#psidshort <- psid[psid$age<35,]

#s = tapply(psidshort$ystand,psidshort$id,"var")
#t = tapply(psidshort$ystand,psidshort$id,"mean")
#initial <- tapply(psid$ystand,psid$id,function(x) x[1])
#end <- tapply(psid$ystand,psid$id,function(x) x[8])
#m <- tapply(psid$ystand,psid$id,"length")

#high = which(t>quantile(t,0.9))
#low = which(t<quantile(t,0.1))

#vol = which(s > quantile(s,0.9))
#calm = which(s<quantile(s,0.1))

#highcalm = which(t>quantile(t,0.8) & s < quantile(s,0.1))
#lowvol = which(t<quantile(t,0.1) & s > quantile(s,0.9))

#highvol = which(t>quantile(t,0.8) & s> quantile(s,0.8))
#lowcalm = which(t<quantile(t,0.2) & s<quantile(s,0.2))
