egbar <- function(x, a){ # Oracle Estimator
    a <- sort(a)
    n <- length(x)
    sapply(1:n, function(i) sum(a * dnorm(x[i] - a))/sum(dnorm(x[i] - a)))
}
BDE <- function(y, T = 300, df = 5, c0 = 0.1){
    # Bayesian Deconvolution Estimator: Efron (B'ka, 2016)
    require(splines)
    eps <- 1e-04
    if(length(T) == 1) T <- seq(min(y)-eps, max(y)+eps, length = T)
    X <- ns(T, df = df)
    a0 <- rep(0, ncol(X))
    A <- dnorm(outer(y,T,"-"))
    qmle <- function(a, X, A, c0){
	g <- exp(X %*% a)
	g <- g/sum(g)
	f <- A %*% g
	-sum(log(f)) + c0 * sum(a^2)^.5
    }
    ahat <- nlm(qmle, a0, X=X, A=A, c0 = c0)$estimate
    g <- exp(X %*% ahat)
    #g <- g/integrate(approxfun(T,g),min(T),max(T))$value
    g <- g/sum(g * diff(T)[1])
    z <- list(x = T,y = g)
    class(z) <- "BDE"
    z
}
predict.BDE <- function(f, xx){
    n <- length(xx)
    x <- f$x
    y <- f$y
    sapply(1:n, function(i) sum(x * dnorm(xx[i] - x) * y)/sum(dnorm(xx[i] - x) * y))
}

Tfig.cap <- "Comparison of several fitted $g$-estimates of the mixing density
for a Twin Towers example.  The black KW estimate represents the discrete
mass points produced by the GLmix function of the REBayes package
using a grid of 300 equally spaced values.  The blue and red estimates represent
the $g$-modeling estimates using 5 and 20 degrees of freedom,
respectively.  The penalty parameter $c_0$ is set at 0.1 in the left panel and
at 1.0 in the right panel."

require(REBayes)

set.seed(25)
pdf(file = "tuning.pdf", height = 6, width = 9)
a <- c(runif(500, -1.7, -0.7), runif(1000, 0.7, 2.7))
x <- a + rnorm(1500)
h <- GLmix(x)
h$y <- h$y/3 # reduce mass to make the BDE estimates more visible.
#hist(x, 100, freq = FALSE)
#hist(a,100,col = 2, freq = FALSE, add = TRUE)
par(mfrow = c(1,2))
plot(h, xlab = "x", main = expression(c[0] == 0.1))
g <- BDE(x, df = 20)
lines(g, col = 2, lwd = 1.5)
lines(BDE(x),col = 4, lwd = 1.5)
legend(-4,3.5,c("KW", "E(5)","E(20)"), lwd = 1.5, lty = 1, col = c(1,4,2))
plot(h, xlab = "x", main = expression(c[0] == 1))
g <- BDE(x, df = 20,c0 = 1)
lines(g, col = 2, lwd = 1.5)
lines(BDE(x, c0 = 1),col = 4, lwd = 1.5)
legend(-4,3.5,c("KW", "E(5)","E(20)"), lwd = 1.5, lty = 1, col = c(1,4,2))
dev.off()

