require(dirichletprocess)
require(deconvolveR) # For data
sessionInfo()
set.seed(17)

Likelihood.Tpoisson <- function(mdobj, x, theta){
    num <- c(dpois(x, theta[[1]]))
    denom <- c(ppois(100, theta[[1]])-ppois(0, theta[[1]]))
    return(num/denom)
}

PriorDraw.Tpoisson <- function(mdobj,n=1){
	draws <- rgamma(n, shape = mdobj$priorParameters[1], rate = mdobj$priorParameters[2])
	theta <- list(array(draws, dim = c(1,1,n)))
	return(theta)
		}
		
PriorDensity.Tpoisson <- function(mdobj, theta){
	priorParameters <- mdobj$priorParameters
	thetaDensity <- dgamma(theta[[1]], shape = priorParameters[1], rate = priorParameters[2])
	return(as.numeric(thetaDensity))
	}

MhParameterProposal.Tpoisson <- function(mdobj, oldParams){
		mhStepSize <- mdobj$mhStepSize
		newParams <- oldParams
		newParams[[1]] <- abs(oldParams[[1]] + mhStepSize * rnorm(1))
		return(newParams)
		}

PriorParametersUpdate.Tpoisson <- function(mdobj, clusterParameters, n = 1) {

  hyperPriorParameters <- mdobj$hyperPriorParameters
  priorParameters <- mdobj$priorParameters

  numClusters <- dim(clusterParameters[[1]])[3]
  
    newBeta <- rgamma(n, hyperPriorParameters[1] + priorParameters[1] * numClusters,
                     hyperPriorParameters[2] + sum(clusterParameters[[1]]))

  new_priorParameters <- matrix(c(priorParameters[1],
                                  newBeta[n]),
                                  ncol = 2)
  mdobj$priorParameters <- new_priorParameters
  return(mdobj)
}
TpoissonMd <- MixingDistribution("Tpoisson", priorParameters = c(0.25, 1), 
	hyperPriorParameters = c(1,1/2), "nonconjugate", mhStepSize = c(0.1))	
lambdaPosteriorFrame <- function(dp, xgrid, ci.alpha = 0.05, burnin = 0.5) {
    K <- 1:floor(burnin * length(dp$weightsChain))
    x <- dp$clusterParametersChain[-K]
    w <- dp$weightsChain[-K]
    sfun <- function(x, w){ 
	x <- unlist(x)
	o <- order(x)
	G <- cumsum(c(0,w[o]))
	stepfun(x[o], G/G[length(G)])
    }
    F <- mapply(sfun, x, w)
    G <- sapply(F, function(f, x) f(x), x = xgrid)
    H <- apply(G, 1, quantile, probs = c(ci.alpha/2, 1/2, 1 - ci.alpha/2))
    Z <- list(x = xgrid, Y = t(H))
    class(Z) <- "lambdaPosterior"
    return(Z)
}
plot.lambdaPosterior <- function(x, ...){
    z <- x$x
    y <- x$Y[,2]
    ylo <- x$Y[,1]
    yhi <- x$Y[,3]
    plot(z, y, type = "l", ...)
    polygon(c(z,rev(z)), c(ylo, rev(yhi)), col = "lightblue", border = NA)
}
data(bardWordCount)
w = bardWordCount
y =  rep(1:100, times = w)
dp <- DirichletProcessCreate(y, TpoissonMd)
dp <- Initialise(dp, posterior = FALSE)
dp = Fit(dp,2000, updatePrior = TRUE)
dp$labelsChain <- NULL # Not needed


