# Guvenen Figure
x <- Guvenen[,1]
y <- Guvenen[,2] # Log(f(x))

# Setup Plot Array
par(mfrow = c(1,2))
par(mgp = c(2,1,0))
#Log Concavity is violated
plot(x, y, xlab = "x ~ log income annual increments", ylab = "log f(x)", type = "l")

# Looks like Hellinger Concavity is plausible
plot(x, -1/sqrt(exp(y)), xlab = "x ~ log income annual increments", 
     ylab = expression(-1/sqrt(f(x))), type = "l")

# Estimate 
w <- exp(y)*diff(x)[1]
f <- medde(x, w = w, lambda = - 0.5, alpha = 0.5)
s <- (f$x > -3.7) & (f$x < 3.7)
xx <- f$x[s]
yy <- f$y[s]
zz <- -1/sqrt(yy)
lines(xx,zz,col = "red")
