#' Maximum Entropy [De]Regularized [Bivariate] Density Estimation
#' 
#' Density estimation based on maximum entropy methods
#' 
#' See the references for further details. And also Mosek "Manuals". The
#' acronym, according to the urban dictionary has a nice connection to
#' a term used in Bahamian dialect, mostly on the Family Islands like Eleuthera
#' and Cat Island meaning "mess with" "get involved," "get entangled," "fool
#' around," "bother:"
#' "I don't like to medder up with all kinda people"
#' "Don't medder with people (chirren)"
#' "Why you think she medderin up in their business."
#' 
#' This function is merely an outer wrapper for separate function for univariate
#' and bivariate fitting, see \code{medde1} and \code{medde2} respectively.

#' @param x Data: n by 2 matrix of observations
#' @param ... additional parameters for fitting.
#' @return An object of class "medde1" or "medde2" 
#' @author Roger Koenker and Ivan Mizera
#' @seealso \code{medde1} and \code{medde2}
#' @references  
#' Han, Qiyang and Jon Wellner (2016) ``Approximation and estimation of s-concave 
#' densities via Renyi divergences,'' \emph{Annals of Statistics}, 44, 1332-1359.
#' Koenker, R and I. Mizera, (2010) ``Quasi-Concave Density Estimation''
#' \emph{Annals of Statistics}, 38, 2998-3027.
#' @keywords nonparametric
#' @export 
#' 
medde <- function(x, ...) {
    if(NCOL(x) == 2) z <- medde2(x, ...)
    else z <- medde1(x, ...)
    return(z)
}
