# Simulation Design for crq paper

dgp <- function(x,ctype,b = c(5,1,.3),a = c(6.5,5.5,.75,.3)){
        n <- length(x)
        T <- b[1] + b[2] * x + b[3] * (b[3] + x^2) * rnorm(n)
        if(ctype == 1) C <- rep(a[1],n)
        else C <- a[2] + a[3] * x + a[4] * rnorm(n)
        Y <- pmin(T,C)
        d <- T < C
        list(T=T, C=C, Y=Y, d=d)
        }

R <- 1000
ns <- c(100, 400, 1000)

# Simulation Loop
require(quantreg)

system("hostname")
date()
sessionInfo()
set.seed(1968)

A <- array(0,c(3,6,length(ns),R))

for(j in 1:length(ns)){
 n <- ns[j]
 x <- sort(runif(n)) * 2
 for(i in 1:R){

   z <- dgp(x,1)
   fp <- crq(Surv(z$Y,z$d) ~ x, taus = .5, method = "Por")
   fp2 <- crq(Surv(z$Y,z$d) ~ x + I(x^2), taus = .5, method = "Por")
   fph <- crq(Surv(z$Y,z$d) ~ x, taus = .5, method = "Pen")
   fph2 <- crq(Surv(z$Y,z$d) ~ x + I(x^2), taus = .5, method = "Pen")
   ffp <- crq(Curv(z$Y,z$C, type = "right") ~ x, taus = .5, method = "Pow")
   gmle <- survreg(Surv(z$Y,z$d, type = "right") ~ x, dist = "gaussian")
   A[,,j,i] <- cbind(c(coef(fp,.5),0), coef(fp2,.5), c(coef(fph,.5),0),
        coef(fph2,.5), c(coef(ffp,.5),0),c(coef(gmle),0))
   print(paste("j = ", j, "i = ", i))
   }
}

