require(survival)
Powell.median <- function(y,c){
        R <- function(a,y,c){
                sum(abs(y-pmin(a,c)))
                }
        r <- a <- sort(y)
        for(i in 1:length(a)) {
                r[i] <- R(a[i],y,c)
                }
        mean(a[which(r == min(r))])
        }
KM.median <- function(y,d){
	g <- survfit(Surv(y,d))
        g$time[min(which(g$surv<=.5))]
	}
NA.median <- function(y,d){
	g <- survfit(Surv(y,d),type="fl")
        g$time[min(which(g$surv<=.5))]
	}
L.median <- function(y, cen, rate = .25, ecdf = TRUE){
        #Leurgans synthetic estimate for known G dist.
        o <- order(y)
	y <- y[o]
	cen <- cen[o]
        Fhat <-  rep(0,length(y))
	if(ecdf) Ghat <- ecdf(cen)
	else Ghat <- function(y) pexp(y, rate) 
        for(i in 1:length(y)){
                Fhat[i]  <- mean((y >= y[i]) / (1-Ghat(y[i])))
		}
	j <- min(which(Fhat <= .5))
        (y[j-1] + y[j])/2
        }
M <- 1000
ns <- c(50, 200, 500, 1000)
mmm <- matrix(NA,M,4)
mpo <- matrix(NA,M,4)
mkm <- matrix(NA,M,4)
mna <- matrix(NA,M,4)
ml1 <- matrix(NA,M,4)
ml2 <- matrix(NA,M,4)

for(j in 1:4){
	n <- ns[j]
	for(i in 1:M){
		t <- exp(rnorm(n))
		cen <- rexp(n,.25)
		y <- pmin(t,cen)
		mmm[i,j] <- median(t)
		mkm[i,j] <- KM.median(y,t < cen)
		mna[i,j] <- NA.median(y,t < cen)
		mpo[i,j] <- Powell.median(y,cen)
		ml1[i,j] <- L.median(y,cen)
		ml2[i,j] <- L.median(y,cen,ecdf=FALSE)
		}
	}
