% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqr.R
\name{cqr}
\alias{cqr}
\title{Quantile Regression Survival Analysis with Cure Prospect}
\usage{
cqr(formula, data, taus = 1:9/10, method = "LNA", link = "logit", ...)
}
\arguments{
\item{formula:}{Formula describing the model, this formula uses an extended
form of the R \code{formula} syntax with generic form \code{y|D ~ X|Z} 
where:  \code{y} is the observed event times,\code{D} is the censoring indicator, 
\code{X} are covariates in QR survival model,and \code{Z} are covariates in the 
binary response cure model.}

\item{data:}{Data frame indicating where to find the variables in the formula}

\item{taus:}{Quantiles specified for the QR model,}

\item{method:}{Fitting method desired,}

\item{link:}{Link function for the binary response model}

\item{...:}{other parameters passed to he fitting function, as yet this is only
needed to pass bandwidth parameters for the "LNA" and "Imp" methods.}
}
\value{
An object of class cqr with components:
\item{beta}{estimated QR parameters at the specified \code{taus}.}
\item{gamma}{estimated binary response parameters from cure model}
}
\description{
Quantile Regression Methods for Survival Analysis with Cure Effect
}
\details{
This function implements several estimation methods for fitting survival models
that take the accelerated failure time quantile regression form and incorporate
a positive probability of cure, that is a positive proportion of subjects who
are not susceptible to the event under study.  This proportion is modeled as a
binary response possibly influenced by specified covariates including treatment
variables.  The three fitting methods are described in more detail in the vignette
Koenker and Narisetty (2017) included with this package.
}
\examples{
data(LungCancer)
set.seed(4321)
hn <- c(1, 0.001,0.7164258,0.001)    # the bandwidths
methods <- c("LNA", "Imp", "DA")
fit <- function(D) {
f <- list()
for(i in 1:3)
	f[[i]] <- cqr(y|d ~ hist + age + sex| hist + age + sex, 
	data = D, method = methods[i], h = hn)
	f
	}
f <- fit(D)
}
\references{
Wang HJ, Wang L. 2009.
Locally weighted censored quantile regression.
\emph{Journal of the American Statistical Association} {104}: 1117--1128.

Wu Y, Yin G. 2013.
Cure rate quantile regression for censored data with a survival fraction.
\emph{Journal of the American Statistical Association} {108}: 1517--1531.

Wu Y, Yin G. 2017.
Multiple imputation for cure rate quantile regression with censored data.
\emph{Biometrics} {73}: 94--103.

Yang X, Narisetty NN, He X. 2016.
A new approach to censored quantile regression estimation.
University of Michigan Technical Report.
}
\author{
Roger Koenker and Naveen Narisetty
}
\keyword{nonparametric}
