# Make table and figure based on fitting of the Lung Cancer data produced by Lungfit.R

load("Lungfit.Rda")
require(Hmisc)

# Table for gamma estimates
g <- sapply(f,function(x) x$gamma)
G <- sapply(Bfit, function(x) sapply(x,function(y) y$gamma)) 
se <- matrix(sqrt(diag(cov(t(G)))),4,3)
g <- format.df(g, dec = 3, numeric.dollar = FALSE)
se <- format.df(se, dec = 3, numeric.dollar = FALSE)
Lungg <- matrix(0,4,3)
for(i in 1:4){
    for(j in 1:3){
	Lungg[i,j] <- paste("$\\underset{(", se[i,j], ")}{",g[i,j],"}$",sep="")
    }
}
dimnames(Lungg) <- list( c("Intercept","Histology","Age","Sex"), c("LNA", "Imp", "DA"))
gcap <- "Estimates of the $\\gamma$  parameters for the logistic cure model, bootstrap
standard errors in parentheses"
latex(Lungg, rowlabel = "", caption = gcap, caption.loc = "bottom", label = "Lungg")

# Figure for beta estimates
coefname <- c("Intercept","Histology","Age","Sex") 
method <- c("LNA", "Imp", "DA")
b <- array(sapply(f,function(x) x$beta), c(4,9,3))
B <- sapply(Bfit, function(x) sapply(x,function(y) y$beta)) 
se <- sqrt(diag(cov(t(B))))
se <- array(se, c(4,9,3))
taus <- 1:9/10
pdf("Lungb.pdf", height = 9, width = 6.5)
par(mfrow = c(4,3))
za <- qnorm(0.90)
for(i in 1:4){
    for(j in 1:3){
	s <- (!is.na(se[1,,j]) & (se[i,,j] < 3))
	ses <- za * c(se[i,s,j], rev(-se[i,s,j]))
	ts <- c(taus[s], rev(taus[s]))
	bs <- c(b[i,s,j], rev(b[i,s,j]))
	if(i == 1) ylims = c(0,6)
	else ylims = c(-2,2)
	tit <- paste(coefname[i], "-- ", method[j])
	plot(ts, bs + ses, type = "n", ylim = ylims, main = tit,
	     xlab = expression(tau), ylab = expression(beta (tau)))
	polygon(ts, bs + ses, col = "lightblue")
	lines(taus, b[i,,j], lwd = 1.5)
	abline(h = 0, col = 2, lwd = 1.5)
    }
}
dev.off()

