
# Reproduction of Simulations of Bottai and Zhang  
require(quantreg)

#########################################################
# R function for
# Laplace Regression with Censored Data
# by Matteo Bottai and Jiajia Zhang
# published in Biometrical Journal
# Version 1.0 (May 24, 2010)
#########################################################


#########################################################
# Loglikelihood function (called by the laplace function)

l = function(t,x,y,d,p,w=1) {
	k = ncol(x)
	s = t[k+1]
	z = (y-x%*%t[1:k])/s
	-sum(w*ifelse(z<=0,
		d*((1-p)*z + log(p*(1-p)/s)) +
		(1-d)*log(1-p*exp((1-p)*z))
		,
		d*((-p)*z + log(p*(1-p)/s)) +
		(1-d)*((-p)*z + log(1-p))
		))
	}
#########################################################
# Laplace regression function -- Modified [RWK: March, 2011] 
# The arguments are
#     y: outcome vector
#     x: design matrix (with the intercept)
#     d: censoring vector (0=censored, 1=uncensored)
#     p: quantiles to be estimated 

laplace = function(y,x,d, p = 1:3/4, warnings = FALSE) {
	op <- options()$warn
	if(!warnings) options(warn = -1)
	A <- matrix(0,ncol(x) + 1,length(p))
	for(i in 1:length(p))
		A[,i] <- optim(par=c(rep(0,ncol(x)),1),fn=l,x=x,y=y,d=d,p=p[i])$par
	A
	}
#########################################################

# Type I Extreme Value aka Gumbel Distribution
pev1 <- function(x) exp(-exp(-x))
qev1 <- function(p) -log(-log(p))
rev1 <- function(n) qev1(runif(n))

rf1 <- function(n) rnorm(n)
rf2 <- function(n, s = 1.282550) rev1(n)/s #s = pi/sqrt(6)
rf3 <- function(n, s = 1.732051) rt(n,3)/s #s = sqrt(3)
rfs <- c(rf1,rf2,rf3)

set.seed(1917)


response <- function(M, rf, X, a = c(35,150,35)){
        n <- nrow(X)
	u <- rf(n)
	t <- exp(switch(M,
	   X %*% c(-2,6,0,0) + u, 
	   X %*% c(1,0,2,3)  + u, 
	   X %*% c(-2,6,0,0) + X[,2] * u)) 
	c <- runif(n,0, a[M])  # censoring variable -- about 30% censoring
	y <- pmin(t,c)  # observed censored outcome
	d <- as.numeric(t < c)  # censoring indicator
	list(y = y, d = d)
	}

R <- 100
ns <- c(100,500,1000,10000)
A <- array(0,c(3,4,R))
B <- array(0,c(3,4,R))
D <- array(0,c(4,R))
for(i in 1:length(ns)){
      n <- ns[i]
      x1 <- runif(n)  # continuous covariate
      x2 <- rnorm(n)  # continuous covariate
      x3 <- as.numeric(runif(n) < 0.5)  # binary covariate
      X <- cbind(1,x1,x2,x3)
      for(j in 1:R){
	Z <- response(1, rfs[[1]], X)
	A[,i,j] <- system.time(laplace(log(Z$y), X, Z$d)[1:4,])[1:3]
	B[,i,j] <- system.time(coef(crq(Surv(log(Z$y),Z$d)~ x1 + x2 + x3,
		taus = 1:3/4, method = "Portnoy"), taus = 1:3/4))[1:3]
	}
   print(i)
   }
