# Analysis of sim2 output

load("sim2.Rda")
qf1 <- function(p) qnorm(p)
qf2 <- function(p, s = 1.282550) qev1(p)/s #s = pi/sqrt(6)
qf3 <- function(p, s = 1.732051) qt(p,3)/s #s = sqrt(3)
qfs <- c(qf1,qf2,qf3)
taus <- 1:3/4

A <- array(A,c(12,4,R))
B <- array(B,c(12,4,R))
for(i in 1){
   b <- switch(i, c(-2,6,0,0), c(1,0,2,3), c(-2,6,0,0)) 
   g <- switch(i, c(1,0,0,0), c(1,0,0,0), c(0,1,0,0)) 
   for(j in 1){
      Qt <- qfs[[j]](taus)
      H <- c(rep(b,3) + c(g %o% Qt))
      A <- A - H
      B <- B - H
      }
   }
ABias <- c(abs(apply(A,1:2,mean)))*100
BBias <- c(abs(apply(B,1:2,mean)))*100
ARMSE <- c(sqrt(apply(A^2,1:2,mean)))
BRMSE <- c(sqrt(apply(B^2,1:2,mean)))

# Now make figures

require(lattice)
G <- expand.grid(1:4,1:3,1:4)
Beta <- factor(G[,1],labels =
   c( expression(beta [1]), expression(beta [2]), expression(beta [3]), expression(beta [4])))
Tau  <- factor(G[,2],labels = paste(expression(tau)," = ", 1:3/4, sep=""))
ns <- c(100,500,1000,10000)
n <- ns[G[,3]]
fig1 <- xyplot(ABias + BBias ~ log(n) | Beta + Tau, type = c("b","b"),
	distribute.type = TRUE,
	par.settings = simpleTheme(pch = c(1,16)), ylab = "Bias")
ARMSE <- sqrt(n)*ARMSE
BRMSE <- sqrt(n)*BRMSE
fig2 <- xyplot(ARMSE + BRMSE ~ log(n) | Beta + Tau, type = c("b","b"), 
	distribute.type = TRUE,
	par.settings = simpleTheme(pch = c(1,16)),ylab = "RMSE")
pdf(file = "fig1.pdf", height = 6, width = 9)
print(fig1)
dev.off()
pdf(file = "fig2.pdf", height = 6, width = 9)
print(fig2)
dev.off()
