# Analysis of sim1 output

load("sim1.Rda")
qf1 <- function(p) qnorm(p)
qf2 <- function(p, s = 1.282550) qev1(p)/s #s = pi/sqrt(6)
qf3 <- function(p, s = 1.732051) qt(p,3)/s #s = sqrt(3)
qfs <- c(qf1,qf2,qf3)
taus <- 1:3/4

A <- array(A,c(12,3,3,R))
B <- array(B,c(12,3,3,R))
H <- array(0,c(12,3,3))
for(i in 1:3){
   b <- switch(i, c(-2,6,0,0), c(1,0,2,3), c(-2,6,0,0)) 
   g <- switch(i, c(1,0,0,0), c(1,0,0,0), c(0,1,0,0)) 
   for(j in 1:3){
      Qt <- qfs[[j]](taus)
      H[,i,j] <- c(rep(b,3) + c(g %o% Qt))
      A[,i,j,] <- A[,i,j,] - H[,i,j]
      B[,i,j,] <- B[,i,j,] - H[,i,j]
      }
   }
ABias <- apply(A,1:3,mean)
BBias <- apply(B,1:3,mean)
ARMSE <- sqrt(apply(A^2,1:3,mean))
BRMSE <- sqrt(apply(B^2,1:3,mean))

# Now make tables

require(Hmisc)
RMSE <- matrix(ARMSE/BRMSE,12,9)
rnames <- rep(
   c("$\\hat \\beta_0$", "$\\hat \\beta_1$", "$\\hat \\beta_2$", "$\\hat \\beta_3$"),3)
cnames <- rep(paste("F",1:3,sep =""),3)
dimnames(RMSE) <- list(rnames,cnames)
cap <- "Ratio of Root Mean Squared Errors:  Table entries report the ratio
of the RMSE for the Bottai-Zhang (Laplace likelihood) estimator to the corresponding
Portnoy crq estimator, so entries larger than one indicate superior performance
for the Portnoy method.  All entries are based on 1000 replications."  
latex(RMSE,file = "tab1.tex","Coefficient", cgroup = paste("M",1:3,sep = ""),
	rgroup = paste("$\\tau = $",1:3/4),
	dec = 2, caption = cap, label = "tab1", caption.loc = "bottom")


      
