\name{QBFit}
\alias{QBFit}
\title{
    Fitting function for QB Models
}
\description{
    Fits a quantile regression paired comparison model to Kaggle data
    as described in Koenker and Bassett (2010), and a copula model
    describing the dependence of the score pairs.
}
\usage{
QBFit(D, J = 199, copula = frankCopula(2.5, dim = 2), start = 2.5, seed = 42)
}
\arguments{
  \item{D}{
      Data frame made from the Kaggle files.
}
  \item{J}{
      Number of (equally spaced) quantiles to be estimated.
}
  \item{copula}{
      copula model to be estimated 
}
  \item{start}{
      Starting value for copula parameter.
  }
  \item{seed}{
      Seed for dithering the design matrix.
}
}
\details{
    Uses the sparse matrix version of the QR interior point algorithm.
    For 2015 this needs to be expanded to deal with multiple seasons, etc.
}
\value{
    Returns a matrix of coefficients with column dimension J.
    And a copula function describing the dependence of scores.
}
\references{
    Koenker, R. and G. Bassett (2010) March Madness, Quantile Regression 
    Bracketology and the Hayek Hypothesis, J. of Bus. and Econ. Statistics, 
    28, 26-35.
}
\author{
    Roger Koenker
}
\keyword{Regression}
