\name{LKaggle}
\alias{LKaggle}
\title{Kaggle Loss Evaluation }
\description{
    Function to predict probabilities for a specified year and evaluate
    the Kaggle (logistic) loss function for the predicted probabilities.
}
\usage{
LKaggle(year, a = 1:5, n = 20, eps = 1/200)
}
\arguments{
  \item{year}{ Year between 1985 and 2014}
  \item{a}{ Shrinkage parameter for Beta(a,a) prior for phats }
  \item{n}{ Nominal sample size for the phats viewed as binomials }
  \item{eps}{ Tolerance parameter to bound phats away from zero }
}
\details{
    Presumes that fitted objects are available as \code{data(FXXXX)},
    and that the Kaggle csv file for tournament results is available in
    the current working directory.  The Loss is logistic in the predicted
    probabilities and  linear in the binary actual tournament outcomes.
    Shrinkage via a is available and employs a Beta(a,a) prior, but this
    doesn't seem to help.
}
\value{
\item{Loss }{Loss for the phat vector and its shrunken variants }
\item{H}{Detailed matrix of estimated probabilities for each game and outcome}
}
\author{ Roger Koenker }
\examples{
\dontrun{
# Initial Test 
L <- matrix(0,6,30)
years <- 1985:2014
for(k in 1:length(years))
    L[,k] <- LKaggle(years[k])$Loss
dimnames(L)[[1]] <- paste("a =", 0:5)
matplot(years,t(L), type = "l")
}
}
\keyword{methods}
