QBRead <- function (year = 2014) {
    seeds <- read.csv("tourney_seeds.csv", header = TRUE, stringsAsFactor = FALSE)
    seeds <- seeds[seeds[,1] == year, ]
    slots <- read.csv("tourney_slots.csv", header = TRUE, stringsAsFactor = FALSE)
    slots <- slots[slots[,1] == year, ]
    teams <- read.csv("teams.csv", header = TRUE, stringsAsFactor = FALSE)
    d <- read.csv("regular_season_compact_results.csv", header = TRUE)
    d <- d[d[,1] == year, ]
    if(year == 2008) d <- d[!(d[,3] == 1223 | d[,5] == 1223),] # Damn Houston Baptists
    d[, 3] <- factor(d[, 3])
    d[, 5] <- factor(d[, 5])
    f <- read.csv("teams.csv", header = TRUE)
    d$wteam <- factor(d$wteam, f$team_id, f$team_name)
    d$lteam <- factor(d$lteam, f$team_id, f$team_name)
    D <- d
    D[D$wloc == "A", ] <- d[d$wloc == "A", c(1:2, 5:6, 3:4, 7:8)]
    D[, 7] <- c(D$wloc != "N")
    D <- D[, 3:7]
    dimnames(D)[[2]] <- c("H", "Hscore", "A", "Ascore", "Home")
    D[, 1] <- factor(D[, 1])
    D[, 3] <- factor(D[, 3])
    Nteams <- levels(D[, 1])
    Mteams <- levels(D[, 3])
    if (!all.equal(Nteams, Mteams)) 
        stop("Team names don't match")
    Nteams <- data.frame(Number = teams[match(Nteams, teams[, 
        2]), 1], Nteams)
    Tournament <- list(seeds = seeds, slots = slots, teams = teams, 
        Nteams = Nteams)
    list(D = D, Tournament = Tournament)
}
