
QBFit <- function(D, J = 199, copula = frankCopula(2.5, dim=2), 
		  start = 2.5, seed = 42){ 
    # Make the design matrix and response vector
    y <- c(D[,2],D[,4])
    H <- model.matrix(~H, data = D)[,-1]
    A <- model.matrix(~A, data = D)[,-1]
    X <- rbind(cbind(H, -A), cbind(A, -H))
    X <- cbind(intercept = 1, Home = c(D[,5], 0 * D[,5]), X)
    X <- as.matrix.csr(X)
    
    # Dither design slightly to assure unique solutions.
    if(length(seed)) set.seed(seed)
    X@ra <- X@ra + rnorm(length(X@ra))/1000

    # QPCM Fitting
    cntl <- sfn.control(tmpmax = 80000, nsubmax = 80000) # This may need adjustment
    h <- rq.fit.sfn(X,y,tau = .5, control = cntl)$coef
    taus <- 1:J/(J+1)
    coef <- matrix(0, length(h),J)
    for(j in 1:J){
		coef[,j] <- rq.fit.sfn(X,y,tau = taus[j], control = cntl)$coef
	    }
    dimnames(coef)[[1]] <- dimnames(X)[[2]]

    # Copula Fitting
    R <- as.matrix(X %*% coef)
    R <- apply(R < y, 1, sum)
    nR <- length(R)/2
    U  <- R[1:nR] + runif(nR,0,.5)
    V  <- R[(nR+1):(2*nR)] + runif(nR,0,.5)
    W <-  cbind(U,V)/(J+1)
    copula <- fitCopula(copula, W, start = start)@copula 
    list(coef = coef, W = W, copula = copula)
}
