LKaggle <- function(year, a = 1:5, n = 20, eps = 1/200) {
    d <- read.csv("tourney_compact_results.csv", header = TRUE)
    d <- d[d[,1] == year, ]
    D <- d[,c(3,5)]
    y <- D[,1] < D[,2] # Tournament results
    G <- t(apply(D,1,sort)) # Tournament matchups
    data(list = list(paste("F", year, sep = "")), envir = environment())
    Fit <- F$coef
    copula <- F$copula
    Nteams <- QBRead(year)$Tournament$Nteams
    g1 <- factor(Nteams[match(G[,1], Nteams[,1]),2], Nteams[,2])
    g2 <- factor(Nteams[match(G[,2], Nteams[,1]),2], Nteams[,2])
    G <- data.frame(g1,g2)
    m <- nrow(G)
    J <- ncol(Fit)
    g <- rep(0, m)
    u <- (1:J)/(J + 1)
    v <- (1:J)/(J + 1)
    W <- as.matrix(expand.grid(u, v))
    P <- matrix(dCopula(W, copula = copula), J, J)
    H <- model.matrix(~G[, 1] - 1)[, -1, drop = FALSE]
    A <- model.matrix(~G[, 2] - 1)[, -1, drop = FALSE]
    X <- rbind(cbind(H, -A), cbind(A, -H))
    X <- cbind(1, 0, X)
    R <- X %*% Fit
    for (i in 1:m) 
	g[i] <- mean((outer(R[i, ], R[m + i, ], "-") > 0) * P)
    phat <- pmin(pmax(eps, g), 1 - eps)
    pish <- function(p, a, n) (a + p * n + 1)/(2 * a + n + 2)
    Phat <- outer(phat, c(1,a)) 
    for(i in 1:length(a)) Phat[,i+1] <- pish(phat, a[i], n)
    H <- data.frame(G[,1], G[,2], Phat, y)
    Loss <- - apply(y * log(Phat) + (1-y) * log(1 - Phat), 2, mean)
    list(Loss = Loss, H = H)
}

