# Monte Carlo simulation a la Ruppert Carroll and Wand Section 17.5.1

# Some initializations plotit must be false to use foreach....
   plotit = FALSE
   if(plotit){
      X11(width = 9, height = 4)
      par(ask = FALSE)
      par(mfrow = c(1,2))
      }
   require(mgcv)
   require(ConfBands)
   source("plot.gam.R") # Modified gam to return pd and to plot 2se bands
   source("plot.scbm.R") # Modified ConfBands function to return bands, 
   require(doMC) # this loads multicore and foreach automatically too.
   registerDoMC(8) # intention to use 8 cores

   require(quantreg)
   options(warn = -1) # turn off annoying warnings about tiny diagonals


   fitrqss <- function(x,y,g0 = NULL){
     g <- function(lam,y,x) AIC(rqss(y ~ qss(x, lambda = lam)),k = -1) 
     lamstar <- optimize(g, interval = c(0.001, .5), x = x, y = y)
     f <- rqss(y ~ qss(x, lambda = lamstar$min))
     B <- plot(f, bands = "both")
     bandg <- B[[1]]
     gtrue <- g0(bandg$x,4)
     lines(bandg$x, gtrue, col = "red")
     ghat <- (bandg$bhi + bandg$blo)/2
     gmise <- mean((ghat - gtrue)^2)
     gmiae <- mean(abs(ghat - gtrue))
     gcove <- 1 - mean((gtrue < bandg$blo[,2]) | (gtrue > bandg$bhi[,2]))
     hcove <- 1 - mean((gtrue < bandg$blo[,1]) | (gtrue > bandg$bhi[,1]))
     c(gmise, gmiae, gcove, hcove, attributes(lamstar$objective)$edf)
     }
   fitmgcv <- function(x,y,g0 = NULL){
     gfit <- gam(y ~ s(x, bs = "os", k = 40)) # ConfBands needed for O-splines
     h <- scbM(gfit)
     g <- plot(gfit, shift = gfit$coef["(Intercept)"], seWithMean = TRUE)
     Hband <- plot(h, grid = 100)
     x <- g[[1]]$x
     gtrue <- g0(x,4) 
     x <- Hband[,1]
     htrue <- g0(x,4) 
     lines(x,gtrue,col = "red")
     title("MGCV Estimate")
     ghat <- g[[1]]$fit + gfit$coef["(Intercept)"]
     blo <- ghat -  g[[1]]$se
     bhi <- ghat +  g[[1]]$se
     ghat <- (bhi + blo)/2
     gmise <- mean((ghat - gtrue)^2)
     gmiae <- mean(abs(ghat - gtrue))
     gcove <- 1 - mean((gtrue < blo) | (gtrue > bhi))
     hcove <- 1 - mean((htrue < Hband[,2]) | (htrue > Hband[,3]))
     c(gmise, gmiae, gcove, hcove, sum(gfit$edf))
     }

# Now the setup for the simulation
date()
system("hostname")
sessionInfo()
set.seed(1968)
n <- 400
x <- sort(runif(n))
sigma <- 0.2
R <- 1000
g0 <- function(x, j) sqrt(x *(1-x)) * sin(2*pi*(1 + 2^((9-4*j)/5))/(x + 2^((9-4*j)/5)))
g0x <- g0(x,4)
dgp <- function(x,f=rnorm,j=2,sigma=.2,gamma=0)
	f(length(x))*sigma*(1+gamma*x)
rt1 <- function(n) rt(n,1)
rt3 <- function(n) rt(n,3)
rchisq3 <- function(n) rchisq(n,3) - 3
fs <- c(rnorm,rt3,rt1,rchisq3)
gammas <- c(0,1)
H <- expand.grid(1:4,1:2)
J <- nrow(H)

AJ <- foreach(j = 1:J) %dopar% {
 A <- array(0,c(5,2,R))
 for(i in 1:R){
   gamma <- gammas[H[j,2]]
   yy <- y <- g0x + dgp(x, f = fs[[H[j,1]]], gamma = gamma)
   if(H[j,1] == 4) #recenter chisq case to have conditional median 0
      yy <- y  - (2.365974 - 3)*sigma*(1+gamma * x)
   A[,1,i] <- fitrqss(x,yy, g0)
   A[,2,i] <- fitmgcv(x,y, g0)
   }
 A
}
