# Analysis of mc2.R's results: 
# Each component of AJ is a 30 by 1000, the last 25 rows 
# are the pvalues of lasso components

load("mc2.Rda")
R <- matrix(0,24,8)
for(i in 1:8){
	B <- AJ[[i]][7:30,]
	R[,i] <- apply(B < 0.05,1,mean)
	}
# At this point R is 24 by 8 -- Now aggregate over groups
s1 <- apply(R[1:6,],2,mean) # Freqs for significant covariates
s2 <- apply(R[7:12,],2,mean) # Freqs for correlated insignificant covariates
s3 <- apply(R[13:24,],2,mean) # Freqs for uncorrelated insignificant covariates
S <- rbind(s1,s2,s3)

# Now deal with the ghat and bandaid components.

MCtab <- function(A){
	# Input A is a 5 by 1000 array 
	# Output is a 7-vector
	# Note that the second apply in the next line computes uniform coverages
	A <- c(apply(A,1,mean), apply(A==1,1,mean)[-c(1:2,5)])
	A <- A[c(1,2,5,3,4,6,7)]
	A[1] <- sqrt(A[1])
	A
	}
B <- NULL
for(j in 1:8)
	B <- rbind(B,MCtab(AJ[[j]][1:5,]))
B <- cbind(B,t(S[1:2,]))
	
dimnames(B) <- list(rep(c("iid error","linear scale"),4),
	c("RMISE","MIAE","MEDF", "Pband","Uband", 
		"Pband","Uband","Positives","Negatives"))
cgrp <- c("Accuracy","Pointwise","Uniform","Covariates")
rgrp <- c("Gaussian", "$t_3$","$t_1$","$\\chi_3^2$")
cap <- "Performance of Penalized Estimators and Their Confidence Bands: 
	With Lasso Covariate Selection"
latex.table(B, file = "mc2a", rowlabel ="",cgroup = cgrp, n.cgroup = c(3,2,2,2),
	rgroup = rgrp, dec = 3, caption = cap)
