# Analysis of mc1.R's results: 

MCtab <- function(A){
	# Input A is a 5 by 2 by 1000 array 
	# Output is a 2 by 7 matrix with rows of Table 1-2 in them.
	# Note that the second apply in the next line computes uniform coverages
	A <- t(rbind(apply(A,1:2,mean), apply(A==1,1:2,mean)[-c(1:2,5),]))
	A <- A[,c(1,2,5,3,4,6,7)]
	A[,1] <- sqrt(A[,1])
	A
	}
load("mc1.Rda")
B1 <- NULL
for(j in 1:4)
	B1 <- rbind(B1,MCtab(AJ[[j]]))
B2 <- NULL
for(j in 5:8)
	B2 <- rbind(B2,MCtab(AJ[[j]]))
dimnames(B1) <- dimnames(B2) <- list(rep(c("rqss","gam"),4),
	c("RMISE","MIAE","MEDF", "Pband","Uband", "Pband","Uband"))
cgrp <- c("Accuracy","Pointwise","Uniform")
rgrp <- c("Gaussian", "$t_3$","$t_1$","$\\chi_3^2$")
cap1 <- "Performance of Penalized Estimators and Their Confidence Bands: IID Error Model"
cap2 <- "Performance of Penalized Estimators and Their Confidence Bands: Linear Scale Model"
latex.table(B1, file = "mc1a1", rowlabel ="",cgroup = cgrp, n.cgroup = c(3,2,2),
	rgroup = rgrp, dec = 3, caption = cap1)
latex.table(B2, file = "mc1a2", rowlabel ="",cgroup = cgrp, n.cgroup = c(3,2,2),
	rgroup = rgrp, dec = 3, caption = cap2)


	
	
