# TV(g')
# See: https://github.com/yromano/cqr/blob/master/cqr_synthetic_data_example_1.ipynb
require(quantreg)
source("conformal.R")
set.seed(1729)
n = 7000
x = c(0,5, runif(n, 0, 5)) # Docs sez U[1,5], code sez U[0,5]
y = rpois(n+2, sin(x)^2 + 0.1) + 0.03*x*rnorm(n+2) + 25*(runif(n+2) < 0.01) * rnorm(n+2)
D = data.frame(y = y, x = x)
pdf("TV1.pdf", height = 6, width = 6)
plot(x,y, cex = .25, ylim = c(-2,6), col = 'grey')
newx = seq(0,5,by = 0.05)
f = conformal(y ~ qss(x,lambda = .5), split = 2/7, data = D, newdata = list(x = newx))
plot(f$qlo, add = TRUE, titles = "", rug = FALSE, col = 2, lwd = 3)
plot(f$qhi, add = TRUE, titles = "", col = 2, rug = FALSE, lwd = 3)
lines(newx, f$pred[,1], col = 4)
lines(newx, f$pred[,2], col = 4)
dev.off()

