# Reproduction of Figure 1 of Johansen and Johnstone

pdf("JJFig1.pdf",height = 6, width = 5)
u <- seq(0,pi/2,length=100)
plot(cos(u),sin(u),bty = "n",type = "l", xaxt = "n", yaxt = "n", xlab = "", ylab = "")
v <- u[33]
segments(0,0,cos(v),sin(v))
segments(cos(v),0,cos(v),sin(v))
segments(cos(v),sin(v),1,0)
segments(0,0,1,0)
segments(0,0,0,1)
lines(.1*cos(u[1:33]),.1*sin(u[1:33]))
text(.14*cos(u[13]),.14*sin(u[15]),expression(theta),cex = 1.5)
text(1.07*cos(v),1.07*sin(v),expression(gamma (t)),cex = 1.5)
text(cos(v),-.03,"w",cex = 1.5)
text(1,-.03,"1",cex = 1.5)
dev.off()
