#Table 5.3 source file -- Power Monte - Carlo for iid linear model
#
#Input is:
#	mc.a1.[G,ti,x4].500 arrays of dim=c(2,500,3,2) where dim numbers are:
#	1.  LR,LM
#	2.  replications
#	3.  q's {1,2,4}
#	4.  n's {100,500}
#Andrew's critical values for alpha in {.1,.05,.01}, q in {1,2,4}
ca <- matrix(c( 8.19, 11.2, 15.62, 9.84, 12.93, 17.56, 13.01, 16.44, 21.54), 3)
tab <- NULL
#loop over distributions:
for(raw in list(mc.a1.G.500$Tn,mc.a1.t1.500$Tn,mc.a1.x4.500$Tn)){
	decision <- raw
	for(i in 1:3){
		#loop on alpha level of the test
		for(j in 1:3){
			#loop on degrees of freedom of test
			decision[,,j,] <- raw[,,j,]>ca[j,i]
			}
		tab <- c(tab,apply(decision,c(1,3:4),"sum"))
		}
	}
#Now do summary of F-test results in a similar manner
#loop over distributions:
tab.F_NULL
alphas_c(.1,.05,.01)
qs_c(1,2,4)
ns_c(100,500)
for(raw in list(mc.a1.G.Fs,mc.a1.t1.Fs,mc.a1.x4.Fs)){
        decision <- raw
        for(i in 1:3){
		alpha_alphas[i]
                #loop on alpha level of the test
                for(j in 1:3){
			q_qs[j]
                        #loop on degrees of freedom of test
			for(k in 1:2){
				n_ns[k]
                        	decision[,j,k] <- raw[,j,k]>qf(1-alpha,q,n-q-1)
				}
                        }
                tab.F <- c(tab.F,apply(decision,c(2:3),"sum"))
                }
        }
#rescale to get percentage of rejections of 500
tab <- tab/500
tab.F <- tab.F/500
#add F results to others
tab <- rbind(matrix(tab,2),tab.F)
tab <- array(tab,dim=c(3,3,2,3,3))
dimnames(tab) <- list(c("$\\Lambda_n$","$T_n$","F"),c(1,2,4),c(100,500),c(.1,.05,.01),
c("Gaussian","Cauchy","$\\chi_4^2$"))
table.5.3 <- matrix(tab,18,9)
qs_rep(rep(c(1,2,4),2),rep(3,6))
ns_rep(c(100,500),rep(9,2))
table.5.3 <- cbind(ns,qs,table.5.3)
dimnames(table.5.3) <- list(rep(c("$\\Lambda_n$","$T_n$","F"),6),
		c("n","q",rep(c(.10,.05,.01),3)))
latex.table(table.5.3,rowlabel="Test",
caption="Monte Carlo Power of the 
$\\sup \\Lambda_n$ and $\\sup T_n$ Tests
in linear models with iid errors:
The table is based on 500 replications per cell.  Each cell
reports the proportion of rejections of the designated test
at the designated level of significance using the critical
values appearing in Table 5.1 taken from Andrews (1993).  The
model in each case is (5.1) with $x_{1i} \\equiv 1$ and
$\\{ x_{ij}: \\; j=2, ...,p \\}$ iid standard Gaussian, 
$\\beta = (0,.5,0,...,0) \\in R^p$, and
$\\{ u_i \\}$ iid from one the three distributions indicated at the
top of the table.  In each case ${\\mathcal T} = [.05 , .95]$, and
 $q = p-1$.",
cgroup=c("","","Gaussian","Cauchy","$\\chi_4^2$"),
n.rgroup=c(9,9),
n.cgroup=c(1,1,3,3,3),cdec=c(0,0,rep(3,9)))

