#Table 5.2 source file
#Input is:
#	mc.a0.[G,ti,x4].500 arrays of dim=c(2,500,3,2) where dim numbers are:
#	1.  LR,LM
#	2.  replications
#	3.  q's {1,2,4}
#	4.  n's {100,500}
#Andrew's critical values for alpha in {.1,.05,.01}, q in {1,2,4}
ca <- matrix(c( 8.19, 11.2, 15.62, 9.84, 12.93, 17.56, 13.01, 16.44, 21.54), 3)
tab <- NULL
#loop over distributions:
for(raw in list(mc.a0.G.500$Tn,mc.a0.t1.500$Tn,mc.a0.x4.500$Tn)){
	decision <- raw
	for(i in 1:3){
		#loop on alpha level of the test
		for(j in 1:3){
			#loop on degrees of freedom of test
			decision[,,j,] <- raw[,,j,]>ca[j,i]
			}
		tab <- c(tab,apply(decision,c(1,3:4),"sum"))
		}
	}
#rescale to get percentage of rejections of 500
tab <- tab/500
tab <- array(tab,dim=c(2,3,2,3,3))
dimnames(tab) <- list(c("$\\Lambda_n$","$T_n$"),c(1,2,4),c(100,500),c(.1,.05,.01),
c("Gaussian","Cauchy","$\\chi_4^2$"))
table.5.2 <- matrix(tab,12,9)
qs_rep(rep(c(1,2,4),2),rep(2,6))
ns_rep(c(100,500),rep(6,2))
table.5.2 <- cbind(ns,qs,table.5.2)
dimnames(table.5.2) <- list(rep(c("$\\Lambda_n$","$T_n$"),6),
		c("n","q",rep(c(.10,.05,.01),3)))
latex.table(table.5.2,rowlabel="Test",
caption="Monte Carlo Size of the $\\sup \\Lambda_n$ and $\\sup T_n$  Tests:
The table is based on 500 replications per cell.  Each cell
reports the proportion of rejections of the designated test
at the designated level of significance using the critical
values appearing in Table 5.1 taken from Andrews (1993).  The
model in each case is (5.1) with $x_{1i} \\equiv 1$ and
$\\{ x_{ij}: \\; j=2, ...,p \\}$ iid standard Gaussian and
$\\{ y_i \\}$ iid from one the three distributions indicated at the
top of the table.  In each case ${\\mathcal T} = [.05 , .95]$, and
 $q = p-1$.",
cgroup=c("","","Gaussian","Cauchy","$\\chi_4^2$"),
n.rgroup=c(6,6),
n.cgroup=c(1,1,3,3,3),cdec=c(0,0,rep(3,9)))

