"monte.carlo"<-
function(run, ns = c(100, 500), ps = c(1, 2, 4), R = 500, model = expression(
	rchisq(n, 4)))
{
	version <- 1	#function for monte carlo experiments for R1 paper 
#Input:
#	ns-a vector of sample sizes
#	ps-a vector of parameter dimensions, intercept will be appended
#	R -number of replications of each n,p pair
#	model-model to be used to generate y should be of the form:
#		expression(y_rnorm(n),y_rt(n,1),y_rchisq(n,4))
#		this is a list which can be evaluated as eval(methods[[i]])
#Output:
#	result-data structure with the components
#		Tn-array of test statistic realizations
#		seed -initial .Random.seed
#	doc-attribute of result describing in detail how it was created	
#	this uses Todd Taylor's (statlib) dataset document functions
#
#	options(object.size = 150000000)	
	dyn.load("rq.o")
	Tn <- array(0, c(2, R, length(ps), length(ns)))
	seed <- .Random.seed
	for(i in 1:length(ns)) {
		n <- ns[i]
		x <- matrix(rnorm(n * max(ps)), n)
		for(k in 1:R) {
			y <- eval(model)
			print(k)
			for(j in 1:length(ps)) {
				Tn[, k, j, i] <- R1(x[, 1:ps[j]], y)
			}
		}
	}
	dimnames(Tn) <- list(c("LR", "LM"), NULL, paste("p=", ps, sep = ""), 
		paste("n=", ns, sep = ""))
	result <- list(Tn = Tn, seed = seed, model = model)
	doc(result) <- how.created(paste("Test", run, "on", unix("hostname")), 
		text = F)
	return(result)
}
"R1"<-
function(x, y, eps = 0.050000000000000003, x1 = F)
{
#Experimental function to compute R1 and some associated test statistics
	R <- rqr(x, y)$sol
	{
		if(!x1) {
			x2 <- x - mean(x)
			rr <- rqr(, y, dual = T)
		}
		else {
			x2 <- lsfit(x1, x)$resid
			rr <- rqr(x1, y, dual = T)
		}
	}
	p <- rr$sol[1,  ]
	Vhat <- approx(R[1,  ], R[3,  ], xout = p)$y
	Vtilde <- rbind(rr$sol[c(1, 3),  ], Vhat)
	h <- dn(p, length(y))
	trim <- ((p - h) < eps) | ((p + h) > 1 - eps)
	qup <- qrq(rr, (p + h)[!trim])
	qlo <- qrq(rr, (p - h)[!trim])
	s <- (qup - qlo)/(2 * h[!trim])	#sparsity estimate
	lambda <- sqrt(p * (1 - p))
	Ln <- (2/(s * (lambda[!trim]^2))) * Vtilde[3, !trim] * log(Vtilde[2, !
		trim]/Vtilde[3, !trim])
	bhat <- rr$dsol - outer(rep(1, length(y)), (1 - p))
	fit <- apply(bhat - lsfit(x2, bhat)$resid, 2, FUN = vecnorm)
	Lm <- (fit/lambda)^2
	return(c(max(Ln), max(Lm[!trim])))
}
