"rqr"<-
function(x, y, tau = -1, alpha = 0.10000000000000001, dual = F, int = T, tol = 
	0.0001, ci = F, method = "score", interpolate = T, tcrit = T, hs = T)
{
#function to compute regression quantiles
	if(!is.loaded(symbol.For("rq"))) dyn.load("rq_l.o")
	if((tau <= 0 || tau >= 1) && ci) {
		warning("cannot compute confidence intervals for all tau")
		ci <- F
	}
	if(ci && method != "score" && method != "sparsity") {
		stop("method has to be ``score'' or ``sparsity''")
	}
	if(missing(x)) {
		x <- matrix(rep(1, length(y)), length(y))
		int <- FALSE
		if(ci && method == "score") {
			warning("method has been set to ``sparsity'' to compute confidence interval for sample quantile"
				)
			method <- "sparsity"
		}
	}
	else {
		x <- as.matrix(x)
		if(int)
			x <- cbind(1, x)
		else if(ncol(x) == 1 && ci && method == "score") {
			warning("method has been set to ``sparsity'' to compute confidence interval when x has only one column with no intercept"
				)
			method <- "sparsity"
		}
	}
	big <- .Machine$single.xmax
	x <- as.matrix(x)
	p <- ncol(x)
	n <- nrow(x)
	if(n != length(y))
		stop("x and y don't match n")
	nsol <- 2
	ndsol <- 2
	if(tcrit)
		cutoff <- qt(1 - alpha/2, n - p)
	else cutoff <- qnorm(1 - alpha/2)
	if(ci) {
		xxinv <- solve(crossprod(x))
		qn <- 1/diag(xxinv)
	}
	else qn <- rep(0, p)
	t.orig <- tau
	if(tau < 0 || tau > 1 || (ci && method == "sparsity")) {
		nsol <- 4 * n
		lci1 <- F
		ndsol <- nsol
		tau <- -1
	}
	else {
		if(!ci)
			lci1 <- F
		else lci1 <- T
	}
	z <- .Fortran("rqr",
		as.integer(n),
		as.integer(p),
		as.integer(n + 5),
		as.integer(p + 3),
		as.integer(p + 4),
		as.single(x),
		as.single(y),
		as.single(tau),
		as.single(tol),
		flag = as.integer(1),
		coef = single(p),
		resid = single(n),
		integer(n),
		single((n + 5) * (p + 4)),
		single(n),
		as.integer(nsol),
		as.integer(ndsol),
		sol = single((p + 3) * nsol),
		dsol = single(n * ndsol),
		lsol = as.integer(0),
		h = integer(p * nsol),
		qn = as.single(qn),
		cutoff = as.single(cutoff),
		ci = single(4 * p),
		tnmat = single(4 * p),
		as.single(big),
		as.logical(lci1))
	tau <- t.orig
	if(z$flag != 0)
		warning(switch(z$flag,
			"Solution may be nonunique",
			"Premature end - possible conditioning problem in x."))
	if(tau < 0 || tau > 1) {
		z$sol <- matrix(z$sol, p + 3, z$lsol)
		if(length(dimnames(x)[[2]]) == 0) {
			if(int)
				xn <- c("Intercept", paste("X", 1:(p - 1), sep
				   = ""))
			else xn <- paste("X", 1:p, sep = "")
		}
		else {
			xn <- dimnames(x)[[2]]
			if(int)
				xn[1] <- "Intercept"
		}
		dimnames(z$sol) <- list(c("Probility", "Quantile", "Objective", 
			xn), NULL)
		z$h <- matrix(z$h, p, z$lsol)
		if(dual) {
			z$dsol <- matrix(z$dsol, n, z$lsol)
			z[c("sol", "dsol", "h")]
		}
		else z[c("sol", "h")]
	}
	else {
		if(ci) {
			if(method == "score") {
				if(interpolate) {
				  Tn <- matrix(z$tnmat, nrow = 4)
				  Tci <- matrix(z$ci, nrow = 4)
				  Tci[3,  ] <- Tci[3,  ] + (cutoff - abs(Tn[3,  
				    ]))/abs(Tn[4,  ] - Tn[3,  ]) * abs(Tci[4,  
				    ] - Tci[3,  ])
				  Tci[2,  ] <- Tci[2,  ] - (cutoff - abs(Tn[2,  
				    ]))/abs(Tn[1,  ] - Tn[2,  ]) * abs(Tci[1,  
				    ] - Tci[2,  ])
				  Tci[2,  ][is.na(Tci[2,  ])] <-  - big
				  Tci[3,  ][is.na(Tci[3,  ])] <- big
				  dimnames(Tci) <- list(c("Lower Bound", 
				    "Lower Bound", "Upper Bound", "Upper Bound"
				    ), NULL)
				  if(dual)
				    return(coef = z$coef, resid = z$resid, dual
				       = z$dsol[1:n], h = z$h[1:p], ci = Tci[2:
				      3,  ])
				  else return(coef = z$coef, resid = z$resid, h
				       = z$h[1:p], ci = Tci[2:3,  ])
				}
				else {
				  Tci <- matrix(z$ci, nrow = 4)
				  dimnames(Tci) <- list(c("Lower Bound", 
				    "Lower Bound", "Upper Bound", "Upper Bound"
				    ), NULL)
				  if(dual)
				    return(coef = z$coef, resid = z$resid, dual
				       = z$dsol[1:n], h = z$h[1:p], ci = Tci, 
				      Tn = matrix(z$tnmat, nrow = 4))
				  else return(coef = z$coef, resid = z$resid, h
				       = z$h[1:p], ci = Tci, Tn = matrix(z$
				      tnmat, nrow = 4))
				}
			}
			else if(method == "sparsity") {
				z$sol <- matrix(z$sol, p + 3, z$lsol)
				z$dsol <- matrix(z$dsol, n, z$lsol)
				z$h <- matrix(z$h, p, z$lsol)
				se <- diag(rq.omega(z, tau, hs = hs) * xxinv)^
				  0.5
				Tci <- matrix(0, 2, p)
				dimnames(Tci) <- list(c("Lower Bound", 
				  "Upper Bound"), NULL)
				isol <- sum(z$sol[1,  ] <= tau)
				Tcoef <- z$sol[3:(p + 2), isol]
				Tci[1,  ] <- Tcoef - cutoff * se
				Tci[2,  ] <- Tcoef + cutoff * se
				if(dual)
				  return(coef = Tcoef, resid = as.single(y - x %*% 
				    Tcoef), dual = z$dsol[, isol], h = z$h[, 
				    isol], ci = Tci)
				else return(coef = Tcoef, resid = as.single(y - 
				    x %*% Tcoef), h = z$h[, isol], ci = Tci)
			}
		}
		else {
			if(dual)
				return(coef = z$coef, resid = z$resid, dual = z$
				  dsol[1:n], h = z$h[1:p])
			else return(coef = z$coef, resid = z$resid, h = z$h[1:p
				  ])
		}
	}
}
"rq.bandwidth"<-
function(p, n, hs = T, alpha = 0.05)
{
#bandwidth selection for sparsity estimation two flavors:
#	Hall and Sheather(1988, JRSS(B)) rate = O(n^{-1/3})
#	Bofinger (1975, Aus. J. Stat)  -- rate = O(n^{-1/5})
#generally speaking, I prefer the default method which is hs=T
	PI <- 3.1415899999999999
	x0 <- qnorm(p)
	f0 <- (1/sqrt(2 * PI)) * exp(.Uminus((x0^2/2)))
	if(hs == T)
		n^(-1/3) * qnorm(1 - alpha/2)^(2/3) * ((1.5 * f0^2)/(2 * x0^2 + 
			1))^(1/3)
	else n^-0.20000000000000001 * ((4.5 * f0^4)/(2 * x0^2 + 1)^2)^
			0.20000000000000001
}
"R5"<-
function(x, y, alpha = 0.050000000000000003, col.x1 = F, taus = c(
	0.10000000000000001, 0.25, 0.5, 0.75, 0.90000000000000002))
{
#Experimental function to compute R1 and some associated test statistics
#Version 5:  May 3, 1999 Modified to fix x2.tilde problem detected by Cade.
#
#x is the design matrix for the unrestricted model
#col.x1 is the list of cols of the design matrix for the restricted model.
#if col.x1 is FALSE then it is presumed that null model is only an intercept.
#4 processes are returned R1, Ln, Lm, and Tn the last is the new rank process.
#NB:  Repeated rq rqr due to design defect in rqr which should be fixed
#Recall that xbar'bhat is computable from V function
	R <- rqr(x, y)$sol
	{
#transform x2 to residual projection of x2 on x1
		if(!col.x1) {
			x1 <- matrix(1, length(y), 1)
			x2 <- x
			x2.tilde <- x - apply(x, 2, "mean")
			rr <- rqr(x1, y, int = F, dual = T)
		}
		else {
			x1 <- cbind(1, x[, col.x1])
			x2 <- x[,  - col.x1]
			x2.tilde <- lsfit(x1, x2, int = F)$resid
			rr <- rqr(x1, y, int = F, dual = T)
		}
	}
	p <- rr$sol[1,  ]
	pp <- R[1,  ]
	betahat <- NULL
	for(i in 1:length(taus)) {
		betahat <- cbind(betahat, R[ - (1:3), sum(pp < taus[i])])
	}
	Vhat <- approx(R[1,  ], R[3,  ], xout = p)$y
	Vtilde <- rbind(rr$sol[c(1, 3),  ], Vhat)
	R1 <- 1 - Vtilde[3,  ]/Vtilde[2,  ]
	h <- dn(p, length(y))
	trim <- ((p - h) < alpha) | ((p + h) > 1 - alpha)
	qup <- qrq(rr, (p + h)[!trim])
	qlo <- qrq(rr, (p - h)[!trim])
	s <- (qup - qlo)/(2 * h[!trim])	#sparsity estimate
	lambda <- sqrt(p * (1 - p))
	Ln <- (2/(s * (lambda[!trim]^2))) * Vtilde[3, !trim] * log(Vtilde[2, !
		trim]/Vtilde[3, !trim])
	bhat <- rr$dsol - outer(rep(1, length(y)), (1 - rr$sol[1,  ]))
	fit <- apply(bhat - lsfit(x2.tilde, bhat, int = F)$resid, 2, FUN = 
		vecnorm)
	Lm <- (fit/lambda)^2
	ps <- p[!trim]
	Tn <- ps
	eps <- 9.9999999999999995e-07
	for(i in 1:length(ps)) {
		pi <- ps[i]
		h <- rq.bandwidth(pi, n, hs = T)
		bhi <- rr$sol[ - (1:3), sum(p < pi + h)]
		blo <- rr$sol[ - (1:3), sum(p < pi - h)]
		dyhat <- x1 %*% (bhi - blo)
		w <- pmax(eps, (2 * h)/(dyhat - eps))
		x2.tilde <- lsfit(x1, x2, int = F, wt = w)$resid
		Sn <- t(x2.tilde) %*% bhat[, sum(p < pi)]
		Mn <- crossprod(x2.tilde)
		Tn[i] <- t(Sn) %*% solve(Mn) %*% Sn/(pi * (1 - pi))
	}
	return(p, R1, ps, Ln, Lm = Lm[!trim], Tn, betahat)
}
