# London tube toy:  Compute "optimal" route
# Reference:  Galichon, OT, Section 8.4
# Usage: load("London.Rda"); pathway()

pathway <- function(route, city = London){
    require(gurobi)
    if(missing(route)) route <- sample(nrow(city$nodes),2)
    if(189 %in% c(route)) stop("189 is a Phantom Station")
    Phi <- city$links[,4]
    n <- nrow(city$nodes)
    b <- rep(0,n); b[c(route)] <- c(-1,1)
    f <- gurobi(list(A = city$A, obj = Phi, rhs = b, sense = "="))
    path <- city$links[f$x == 1,]
    D <- city$nodes
    nodenames <- attributes(D[,4])$levels
    m <- nrow(path)
    stops <- rep(NA, m + 1)
    stops[1] <- nodenames[route[1]]
    B <- matrix(0,m,4)
    B[1,] <- path[path[,1] == route[1],]
    for(i in 2:m){
	B[i,] <- path[path[,1] == B[i-1,2],]
	stops[i] <- nodenames[B[i,1]]
    }
    stops[m+1] <- nodenames[route[2]]
    Blines <- unique(B[,3])
    L <- city$lines
    plot(D[,3],D[,2],cex = .5, col = "grey", xlab = "longitude", ylab = "latitude")
    points(D[route,3],D[route,2], col = 3:2)
    clines <- L[,3]
    segments(D[B[,1],3], D[B[,1],2], D[B[,2],3], D[B[,2],2], 
	     col = clines[B[,3]], lwd = 1.5)
    legend(x = "bottomright", legend = L[Blines,2], col = clines[Blines], lwd = 1.5)
    title(paste(D[route[1],4],"to", D[route[2],4], ":  ", round(f$objval/1000,2),"km"))
    stops
}   
