
# Make London.Rda object containing relevant Tube data

require(geosphere)
require(Matrix)

London <- list()
D <- read.csv('nodes.csv', header = TRUE)
D <- D[order(D[,1]),]
D <- rbind(D[1:188,],rep(NA,8),D[189:307,]) # Phantom Station! 
London$nodes <- D

L <- read.csv('lines.csv', header = TRUE)
London$lines <- L[order(L[,1]),]

a <- read.csv('links.csv', header = TRUE)
a <- as.matrix(a) # Annoying feature of rbind for dataframes!
a <- rbind(a,a[,c(2,1,3)])
a <- cbind(a,distGeo(D[a[,1],3:2],D[a[,2],3:2]))
London$links <- a

m <- nrow(a)
n <- nrow(D)
A <- sparseMatrix(i = 1:m, j = a[,1],x = -1, dims = c(m,n)) +
        sparseMatrix(i = 1:m, j = a[,2],x = 1, dims = c(m,n))
London$A <- t(A)
save(London, file = "London.Rda")

