Wquantile <- function(x, y, t = 0.5) {
#weighted quantile by brute force (full sorting) for scalar quantile regression
# through the origin model:  Q_{y_i} (t)  = x_i b
#
        ord <- order(y/x)
        b <- (y/x)[ord]
        wabs <- abs(x[ord])
        k <- sum(cumsum(wabs) < ((t - 0.5) * sum(x) + 0.5 * sum(wabs)))
        b[k + 1]
}
wquantile <- function(x, y, tau = 0.5){
    n <- length(x)
    b <- y/x
    w <- abs(x)
    ip <- 1:n
    z <- .Fortran("wquantile",
                  as.double(tau),
                  as.integer(n),
                  as.double(b),
                  as.double(w),
                  as.integer(ip),
                  q = double(1))
    z$q
}

wkuantile <- function(x,y, tau = .5){
    n <- length(x)
    ip <- 1:n
    b <- y/x
    w <- abs(x)
    z <- .Fortran("wkuantile", 
		  as.integer(n), 
		  as.double(b),
		  as.double(w),
		  as.integer(ip),
		  q = as.double(tau))
    z$q
}
# R CMD SHLIB wselect.f wquantile.f
# Note:  wquantile segfaults for n > 1,000,000
dyn.load("wselect.so")
#set.seed(17)
n <- 1000000
y <- rnorm(n)
x <- runif(n)
tau = 0.8
t0 <- system.time(q0 <- Wquantile(x, y, tau))
#t1 <- system.time(q1 <- wquantile(x, y, tau))
t2 <- system.time(q2 <- wkuantile(x, y, tau))
t3 <- system.time(q3 <- rq.fit.pfnb(x, y, tau)$coef)
b <- sort(y/x)
k <- which(b == q0)
h <- 10
b <- b[(k-h):(k+h)]
rho <- function(u,tau) sum(u*(tau - (u < 0)))
Rstar <- rho(y-x*q0,.8)
U <- y - outer(x,b)
plot(b, apply(U,2,rho, tau = 0.8), type = "b")
abline(v = q0)
#abline(v = q1, col = 2)
abline(v = q2, col = 3)
abline(v = q3, col = 4)


