# Comparison of yet other bootstrap options 
require(quantreg)
set.seed(1729) # Has been known to claim singular design matrix
tau = 0.8
ns = rev(c(5000, 25000,125000,625000))
ps = rev(c(2,5,10,20))
T <- array(0, c(length(ns), length(ps), 2))
for(i in 1:length(ns)){
    n = ns[i]
    y = rnorm(n)
    for(j in 1:length(ps)){
	p = ps[j]
	x = matrix(rnorm(n*p),n,p)
	f = rq(y ~ x,tau, method = "fn")
	T[i,j,1] <- system.time(A1 <- summary(f, se = "boot", bsmethod = "pwxy"))[1] 
	T[i,j,2] <- system.time(A2 <- summary(f, se = "boot", bsmethod = "BLB"))[1] 
	print(c(i,j))
    }
}
