# Comparison of bootstrap options 
require(quantreg)
set.seed(1729) # Has been known to claim singular design matrix
tau = 0.8
R = 200
ns = c(5000, 25000,125000,625000)
ps = c(2,5,10,20)
for(i in 1:3)
A <- T <- array(0, c(length(ns), length(ps), 3))
for(i in 1:length(ns)){
    n = ns[i]
    y = rnorm(n)
    for(j in 1:length(ps)){
	p = ps[j]
	X = cbind(1,matrix(rnorm(n*p),n,p))
	b0 = rq.fit(X,y,tau)$coef 
	m0 = (n*p)^(1/2)
	U <- matrix(sample(n, n * R, replace = TRUE), n, R)
	T[i,j,1] <- system.time(A[i,j,1] <- boot.rq.wxy(X, y, U, tau)[1,1])[1] 
	T[i,j,2] <- system.time(A[i,j,2] <- boot.rq.pxy(X, y, U, tau, b0)[1,1])[1] 
	T[i,j,3] <- system.time(A[i,j,3] <- boot.rq.pwxy(X, y, tau, b0, m0 = m0)[1,1])[1] 
	print(c(i,j))
    }
}
dimnames(T) <- dimnames(A) <- list(paste("n=",ns),paste("p=",ps),c("wxy", "pxy","pwxy"))


