# Tests of fitting algorithms for many taus

require(quantreg)
set.seed(1729) # Has been known to claim singular design matrix
ns = c(5000, 25000,125000,625000)
ps = c(2, 5, 10, 20)
taus = 1:49/50
A <- T <- array(0, c(length(ns), length(ps), 3))
for(i in 1:length(ns)){
    n = ns[i]
    y = rnorm(n)
    for(j in 1:length(ps)){
	p = ps[j]
	X = cbind(1,matrix(rnorm(n*p),n,p))
	T[i,j,1] <- system.time(A[i,j,1] <- rq.fit.ppro(X, y, taus)$coef[1,1])[1] 
	T[i,j,2] <- system.time(A[i,j,2] <- rq.fit.pfnb(X, y, taus)$coef[1,1])[1] 
	T[i,j,3] <- system.time(A[i,j,3] <- rq.fit.qfnb(X, y, taus)$coef[1,1])[1] 
	print(c(i,j))
    }
}
rm(x,y)
dimnames(T) <- dimnames(A) <- list(paste("n=",ns),paste("p=",ps),c("ppro", "pfnb","qfnb"))


