require(lattice)
require(latticeExtra)
load("test1.Rda")
D = data.frame(n = rep(ns,4), p = as.factor(rep(ps, each = 5)),
	       br = c(T[,,1]), fn = c(T[,,2]), pfn = c(T[,,3]), sfn = c(T[,,4]))
formula = br + fn + pfn + sfn ~ n | p
scales = list(x = list(log = 10), y = list(log = 10))
lattice.theme <- trellis.par.get()
col <- lattice.theme$superpose.symbol$col[1:4]
T1 = xyplot(formula, data = D, scales = scales, pch = 16,
	       strip = function(..., strip.name) strip.default(..., strip.names = TRUE),
	       key = list(space = "top", lines = list(col = col, lwd = 2), 
			  points = list(pch = 16, col = col), columns = 4, 
			  text= list(dimnames(D)[[2]][3:6])),
	       xscale.components = xscale.components.log10ticks,
	       yscale.components = yscale.components.log10ticks,
	       xlab = "n", ylab = "cpu-seconds", type = "b")
pdf(file = "T1.pdf", height = 5, width = 10)
plot(T1)
dev.off()
