# Tests of fitting algorithms

ns = c(1000, 5000, 25000, 125000,625000 )
ps = c(5, 10, 20, 40)
A <- T <- array(0, c(length(ns), length(ps), 4))
for(i in 1:length(ns)){
    n = ns[i]
    y = rnorm(n)
    for(j in 1:length(ps)){
	p = ps[j]
	X = matrix(rnorm(n*p),n,p)
	T[i,j,1] <- system.time(A[i,j,1] <- rq(y ~ X,  0.75, method = "br")$coef[1])[1] 
	T[i,j,2] <- system.time(A[i,j,2] <- rq(y ~ X,  0.75, method = "fn")$coef[1])[1] 
	T[i,j,3] <- system.time(A[i,j,3] <- rq(y ~ X,  0.75, method = "pfn")$coef[1])[1] 
	T[i,j,4] <- system.time(A[i,j,4] <- rq(y ~ X,  0.75, method = "sfn", data = NULL)$coef[1])[1] 
    }
}
rm(X,y)
dimnames(T) <- dimnames(A) <- list(paste("n=",ns), paste("p=",ps),c("br","fn","pfn","sfn"))


