#figures for unit root rank tests paper
#Test results are generated by the source file HK.s and stored in the
#list HK.test.results, each item in the list is a 3x4x4 array for one of
#the Nelson-Plosser time series.
#
	#1.  l:  lag truncation parameter for Newey West computations
	#2.  tests: Wilcoxon, Normal, Sign in figure they descend in this order 
	#3.  p order of autoregression in ADF model
	#4.  variable number -- names of vars in vnames
#set up the plot
lagl <- c(2,4,6,8)
lagp <- c(1,2,4,8)
critval <- qnorm(c(.01,.05,.1))
lambda <- .33 #scaling factor for plot
seg.length <- .7
series <- c(2,10,(1:14)[-c(2,10)]) #reorder the series
for(k in 1:2){
	s <- HK.test.results[[series[k]]]
	out.file <- paste("fig.",k,".pdf",sep="")
	pdf(out.file,height = 4.5,width=6.5 )
	plot(c(5,5,1:9),0:10,xlab="lag truncation",
			ylab="order of autoregression",type="n")
	for(i in 1:4){
		y1 <- kronecker(lagp,c(1,1,1))-.5*seg.length
		x1 <- kronecker(lagl[i],lambda*(-critval[2]+critval),FUN ="+")
		y2 <- kronecker(lagp,c(1,1,1))+.5*seg.length
		x2 <- kronecker(lagl[i],lambda*(-critval[2]+critval),FUN ="+")
		segments(x1,y1,x2,y2,col=2)
		for(j in 1:4){
			points(lagl[i]+lambda*(-critval[2]+s[,i,j]),
				lagp[j]+seg.length*c(.4,0,-.4),cex=.5,pch="o")
			}
		}
	dev.off()
	}
pdf("fig.3.pdf",height =  11,width=7) 
par(mfrow=c(6,2))
for (k in 3:14){
	s <- HK.test.results[[series[k]]]
	plot(c(5,5,1:9),0:10,xlab="lag truncation",
			ylab="order of autoregression",type="n")
	for(i in 1:4){
		y1 <- kronecker(lagp,c(1,1,1))-.5*seg.length
		x1 <- kronecker(lagl[i],lambda*(-critval[2]+critval),FUN ="+")
		y2 <- kronecker(lagp,c(1,1,1))+.5*seg.length
		x2 <- kronecker(lagl[i],lambda*(-critval[2]+critval),FUN ="+")
		segments(x1,y1,x2,y2,col=2)
		for(j in 1:4){
			points(lagl[i]+lambda*(-critval[2]+s[,i,j]),
				lagp[j]+seg.length*c(.4,0,-.4),cex=.5,pch="o")
			}
		}
	title(NP.names[series[k]])
	print(paste("s=",k))
	}
dev.off()
