# Cost
Cost <- function(x, b = c(2, 0.3, 0.1)) 
	exp(b[1] + b[2] * log(x) + b[3] * log(x)^2)
# Demand
Demand <- function(p){
	n <- length(p)
	z <- .Fortran("demand",as.integer(n),as.double(p),x = double(n),
		PACKAGE = "monopoly")
	return(z$x)
	}
# Profit
Profit <- function(p) {
	x <- Demand(p) 
	p * x - Cost(x)
	}
