# Attempt to estimate profit maximizing pricing policy with Kiefer-Wolfowitz (1952)
# A toy Stochastic Approximation Method for one dimensional maximization

KWopt <- function(f, n, x0 = 15, a0 = 1, a = -1, c0 = 3, c = -1/6){
x <- c(x0, rep(0,n-1))
xp <- xm <- rep(x0,n)
for(k in 2:n){
	h <- c0 * k^c
	xp[k] <- x[k-1] + h
	xm[k] <- x[k-1] - h 
	x[k] = x[k-1] + a0 * k^a * (f(xp[k]) - f(xm[k]))/(2*h)
	}
data.frame(x=x,xm=xm,xp=xp)
}
	
